/*
This do file replicates Figure ## UIP during 2022-2023 FED Hikes

Because of confidentiality issues, we are not providing UIP data. Hence, we provide
the code even it can't be run. We include excel files with aggregate date to reproduce
the figure.
*/

clear
set more off
set graphics on
cls
clear matrix
clear mata 
set maxvar 8000

//Change this directory depending who is running the code
cap cd "Replication_pkg/Data_programs/Data"  

use "LP_data", clear

//Compute first value available for FX debt 
sort IFS_code time_q 
bys IFS_code (time_q): gen long obsno = _n
by IFS_code (time_q) : gen countnonmissing = sum(!missing(FX_debt_f)) if !missing(FX_debt_f)
bysort IFS_code (countnonmissing) : gen tfirst = time_q[1]
bysort IFS_code (countnonmissing) : gen fx_debt_first = FX_debt_f[1]
format fx_debt_first %3.2f
drop obsno countnonmissing

//Compute last value available for FX debt 
//last value 
bys IFS_code (time_q): egen tlast=max(time_q/(!missing(FX_debt_f)))
g double fx_debt_last=FX_debt_f if time_q==tlast 
bys IFS_code: egen max=max(fx_debt_last)
replace fx_debt_last=max 
drop max tlast 
xtset IFS_code time_q


/*******************************************************************************
Drop LICS+ 
*******************************************************************************/
drop if IMF_incomeLevel==3
drop if Name=="Bolivia"
drop if Name=="Cambodia"
drop if Name=="Dominican Republic"
drop if Name=="Jamaica"
drop if Name=="Mongolia"
drop if Name=="Nicaragua"


//UIP 
g g_uip=ln_theta_12m_treasury


global relevant_fx "fx_debt_last"
sum $relevant_fx if Name!="Korea" , d 
global min_fx=r(p25) //Replace by p25
global max_fx=r(p75) //Replace by p75 
g low_fx=1 if ($relevant_fx<=$min_fx)
replace low_fx=0 if ($relevant_fx>=$max_fx)
keep if time_q>=tq(2022q1)
sort Name time_q 
bys IFS_code (time_q): g nuip=100*(g_uip-g_uip[1])

cd "../../Figures/Figure 17"

/*
EM AE
*/
collapse (mean) nuip, by(EM time_q)

line nuip time_q if EM==0 , lc(blue)  lwidth(thick) lp(dash)  ///
	|| (line nuip time_q if EM==1, lc(red) lp(dash) lwidth(thick)),  ///
	xtitle("") xlab(, nogrid)  xlabel(#7, angle(0))  ///
	ytitle("% Change") ylab(, nogrid)  ///
	ti("12 month UIP deviation", size(medium)) ///
	legend(pos(6) label (1 "AE") ///
	label (2 "EM") cols(2)) plotregion(style(none)) name(uip_em,replace) aspect(0.7)
graph export "Fig17.pdf", replace

export excel using "Fig17.xlsx", sheet("Fig17 data") replace firstrow(variables)

